import { parseDynamicText } from "./parsers";


export function injectActionValues(action, valueMap) {
    if (!action || typeof action !== "object") return action;
    
    const newAction = {...action};

    // Object based values
    if (typeof action.value === "object" && !Array.isArray(action.value)) {
        newAction.value = {};
        for (const [k, v] of Object.entries(action.value)) {
            if (typeof v === "string" && v.startsWith("{#")) {
                newAction.value[k] = parseDynamicText(v, valueMap);
            } else {
                newAction.value[k] = valueMap.hasOwnProperty(v) ? valueMap[v] : v;
            }
        }

        // String value (not an object)
    } else if (typeof action.value === "string") {
        newAction.value = action.value.startsWith("{#")
            ? parseDynamicText(action.value, valueMap)
            : valueMap[action.value] ?? action.value;
    }

    // Recurse into confirm/cancel actions
    if (action.type === "confirm") {
        if (Array.isArray(action.confirmAction)) {
            newAction.confirmAction = action.confirmAction.map(inner =>
                injectActionValues(inner, valueMap)
            );
        }
        if (Array.isArray(action.cancelAction)) {
            newAction.cancelAction = action.cancelAction.map(inner =>
                injectActionValues(inner, valueMap)
            );
        }
    }

    return newAction;
}